/*
keyFinder.js
Version 2.06

A JavaScript tool that helps navigate the Java API documentation.

Copyright 2002 - 2004 by Steve Claflin

Currently freeware--licensed freely for use on your own system, but not
for distribution to others.
*/
/*

TODO: fix the extra link problem in package listings (what happens to the top package link)
      note: its pathname is package-summary.html
			similar issue when sorting a categorized listing

TODO: set up a way to reinit after a package change

TODO: fix the 0 entry problem for the firstLetterIndexes at the end of the alphabet

TODO:  find out what the weird entries in firstLetterIndexes are

TODO:  improve wait progress reports

TODO:  fix line 899 bug when searching (disappeared?)


*/

// User settable control variables ----------------------------------

/* Set the following to false if you are using jdk 1.3 or earlier WITH the 
     All Classes listing -- that do not need to be sorted
	 But, package class listings that separate classes, interfaces, etc., into
	   separate groups should be sorted
	 Note that if not sorted the find mechanism uses a different algorithm
*/

var doPFSort = true;

/* Set the following to true if you are using the version with a form
    in a separate frame (necessary for Netscape 4 in Unix, but you may
		it for other situations as well.
*/

var hasControlFrame = false;

/* You can change the following line to customize the time
    interval within which keystrokes belong to same class name
    (in milliseconds, so 1000 = 1 second)
*/

var keyTimeout = 1000;

/* The following is the refresh rate at which the entire script is
    reinitialized.  This is necessary because a location change
    in a frame clears the onUnload/onLoad handlers for that frame,
    so that approach can't be used to refresh keystroke sensing
		in the frame.  Again, the value is in milliseconds.
*/

var refreshRate = 3000;

/* The following is the tree depth.  You might increase this if class
     searching seems too slow/unresponsive (the tradeoff is load time
     for the page will increase).   Since the tree only works with the
     first letter of the class names, increasing the depth beyond 6
     adds nothing; even at 5 many of the nodes are duplicated;
     a level of 3 or 4 is probably optimum.
*/


var firstLetterIndexes = new Array();var letters = new Array();
var currentFirstLetter = '@';


var TREE_DEPTH = 5;

/* When searching backward in TreeNode constructor, and searching forward
   on the second keystroke, the search is performed in jumps, rather than
	 in increments of one.  If it has jumped past the correct spot, it 
	 reverses the jump, with control falling to a final stage with increments
	 of 1.	 These two variables control the size of the jumps.
*/

var JUMP_FWD = 10, JUMP_BK = 10;

/* The following two variables influence highlighting of the class
     that was found
*/

var shouldShowFound = true;
var foundBgColor = "ffdddd";

// Other global variables -------------------------------------------

var CR = 13, ESC = 27, _CharIE = 189, _CharNS6 = 109,
    UP = 38, DN = 40,  PGUP = 33, PGDN = 34,
    ASTERISK1 = 106, ASTERISK2 = 56,
    FIND_CLASS = 0, FIND_METHOD = 1;

var findModes = new Array(), findMode = FIND_CLASS;
    findModes[FIND_CLASS] = "Find Classes";
		findModes[FIND_METHOD] = "Find Methods";
var modeBgs = new Array();
    modeBgs[FIND_CLASS] = 'EEEEFF';
    modeBgs[FIND_METHOD] = 'FFEEEE';
var findModeOK = false;
		
var start = 0, count = 0, keys = "", timer = null, reset = null,
    classLoc, classLocHref, pflinks, _ClassLoc, paused = false;
var link = null, path = null, name = null, lastLink = null;
var isIE = false, isN4 = false, isN6 = false;
var methodA, methodName, methodRow;

var getLinkText;
var oldColor = "blue"
var goTo, setFocusFrame, focusFrame = null;

// added line below for debugging
var sortDone = false;

/* function init()
    Sets initial message and background color,
		then sets a timeout to call the init function (which actually does the work).
		Did this because otherwise the impact of these steps is not seen.
*/

function init() {

  packageFrame.document.body.style.backgroundColor = "ffffdd";
  classLoc = classFrame.location;
	classLocHref = classLoc.href;
  if (doPFSort) classFrame.document.write("<h2>Initializing ... </h2>\n");
  window.status = "Initializing ... ";
  setTimeout("init1();", 100);
}
/* function init1()
    Initializes global variables for browser and class page,
		then calls the reInit function (which needs to be called repeatedly).
*/

function init1() {
  if (typeof keyFinderFrame != 'undefined') hasControlFrame = true;
  if (document.all) isIE = true;
  else if (document.layers) {
	  isN4 = true;
		UP = 60;
		DN = 62;
	}
  else if (document.getElementById) {
	  isN6 = true;
	}
  getLinkText = isN6 ? getLinkTextN6 : getLinkTextOther;
  pflinks = clone(packageFrame.document.links);

// added 20040826	  

  var pflinksData = new Array();
  var oldPFHTML;
  var newPFHTML;
  
  if (doPFSort) {
		for (i=0; i<pflinks.length; i++) {
			var tmp = pflinks[i];
			var tmp2 = getLinkText(tmp);
			var linkTag = '<a href="' + tmp.href + '" target="' + tmp.target + '">' +
					 tmp.innerHTML + '</a><br>\n';
					 
			pflinksData[i] = 
				new LinkObject(linkTag, tmp2);
		}
    classFrame.document.write("<h2>Sorting class frame links ... </h2>\n");
    window.status = "Sorting class frame links ... ";
	  oldPFHTML = packageFrame.document.documentElement.innerHTML;
	  newPFHTML = oldPFHTML.substr(0, oldPFHTML.indexOf('<A '));
	  
	  pflinksData.sort(sortLinks);
    classFrame.document.write("<h2>Setting up JumpFind table ... </h2>\n");
    window.status = "Setting up JumpFind table ...";
	  for (i=0; i<pflinksData.length; i++) {
	    var tmp = pflinksData[i];
	    var tmp1 = tmp.firstChar.toLowerCase();
      if (tmp1 != currentFirstLetter) {
        if (tmp1 == '_') {
          firstLetterIndexes['_'] = i;
          break;
        }
        for (il = currentFirstLetter.charCodeAt(0) + 1; il <= tmp1.charCodeAt(0); il++) {
          firstLetterIndexes[String.fromCharCode(il).toLowerCase()] = i;
        }
        currentFirstLetter = tmp1;
      }
  	  newPFHTML += pflinksData[i].tagData;
    }
//  end addition - also changed sortLinks	  
  	newPFHTML += oldPFHTML.substr(oldPFHTML.lastIndexOf('</A>') + 4);
    classFrame.document.write("<h2>Rewriting class frame links ... </h2>\n");
  	window.status = "Rewriting class frame links ... ";
  	packageFrame.document.write(newPFHTML);
  	packageFrame.document.close();
  	
  	pflinks = clone(packageFrame.document.links);
	
  }
  else {
    //fix this to match above -- done?
    for (i=0; i<pflinks.length; i++) {
      var tmp = getLinkText(pflinks[i]);
      var tmp1 = tmp.charAt(0);
      if (tmp1 != currentFirstLetter) {
        firstLetterIndexes[tmp1] = i;
        if (tmp1 == '_')  break;
        currentFirstLetter = tmp1;
      }
    }
  window.status = "Creating link node tree";
  tree = new TreeNode(pflinks, 0, pflinks.length - 1, 1, TREE_DEPTH, null, "m");
  }
  sortDone = true;

	_ClassLoc = pflinks.length - 1;
	
  while (getLinkText(pflinks[_ClassLoc-1]).charAt(0) == "_") _ClassLoc --;
  if (isN4) shouldShowFound = false;
  goTo = isIE ? goToIE :
         isN4 ? goToN4 : 
         isN6 ? goToN6 : null;
  link = lastLink = pflinks[0];
  if (isN4) {
	packageFrame.document.captureEvents(Event.CLICK);
    packageListFrame.document.captureEvents(Event.CLICK);
		// ? need now ? classFrame.document.captureEvents(Event.CLICK);
  }
  
  setFocusFrame = isIE ? setFocusFrameIE :
                  isN4 ? setFocusFrameN4 : 
                  isN6 ? setFocusFrameN6 : null;
  packageListFrame.document.onclick = setFocusFrame;
	classFrame.document.onclick = setFocusFrame;
	
  if (hasControlFrame) controlFrameInit();
  classFrame.document.write("<h2>Reinitializing ... </h2>\n");
  window.status = "Reinitializing ...";
	
	window.top.onload = reInit;
	classFrame.document.close();
	classFrame.location = classLocHref;
  reInit();
  setFocus();
  window.status = "Ready";
  packageFrame.document.body.style.backgroundColor = "ffffff";
  }
	
/* function reInit()
   Called after an interval of refreshRate, then sets the interval again.
   Sets the key down handlers for each frame (so that it does not matter
   which frame has focus when keys are pressed).
   In form-frame version, sets focus to the text box.
   Sets/resets pflinks in non-form-frame version.
*/

function reInit() {
  pflinks = packageFrame.document.links;
  packageFrame.document.onclick = pfClick;
  classFrame.document.onclick = clearFindModeOK;
  if (!hasControlFrame) initKeys();
  if (reset != null) clearTimeout(reset);
	reset = setTimeout("reInit()", refreshRate);
  }

/* function LinkObject() (object class definition)
   used to pull data from links to speed sorting and rewriting of class list
     tagData                the original tag rewritten (why did I do this rather than use innerHTML?)
     firstChar              first chraracter of linkText
     firstCharIsUnderscore  boolean for special treatment of _ classes
     linkText               the lowercase text of the link for sorting
*/

function LinkObject(tagData, linkText) {
  this.tagData = tagData;
  this.linkText = linkText;
  this.firstChar = linkText.charAt(0);
  this.firstCharIsUnderscore = this.firstChar == '_';
  }


/* function TreeNode() (object class definition)
     array    the array to nodify
		 start    the starting point for searching backward to the first
		          occurence of the letter for this node
		 end      the end point for the first letter search
		 level    the level of this node in the tree
		 depth    overall depth of the tree
		 parent   the node that owns this one
		 side     used in debugging to show if this is an upper or lower node
		 
		 Creates a node in the modified btree used to traverse links faster
     The tree only uses the first letter of a class name
*/

function TreeNode(array, start, end, level, depth, parent, side) {
  this.array = array;
  this.level = level;
  this.depth = depth;
  this.upper = null;
  this.lower = null;
  this.findNode = findNode;  // method that searches this node
  this.array = array;
  this.start = start;
  this.end = end;
  this.parent = parent;
  if (level < depth) 
    this.index = Math.floor(start + (end - start)/2); // split array in half
  else {
    this.index = start;
  }

	var tempP = getLinkText(array[this.index]);      // find first letter of  

  this.letter = tempP.charAt(0); //name at split point
  var tempI;
	while (true) {                // back up to first name whose first
                                // letter matches the letter for this node
		if (this.index > JUMP_BK * 2) {
		  tempI = this.index - JUMP_BK;     
      if (array[tempI].firstChar != this.letter) tempI = this.index - 1;
      }
    else tempI = this.index - 1;
		if (tempI < 0) break;
		if (array[tempI].firstChar != this.letter) break;
		this.index = tempI;
		}

	if (level < depth) {
		//if (parent == null || this.letter != parent.letter) {
			this.lower = 
					new TreeNode(array, start, this.index, level + 1, depth, this, "<");
			this.upper = 
					new TreeNode(array, this.index + 1, end, level + 1, depth, this, ">");
      //}
    }
  }

/* function findNode(ch) (member function of TreeNode class)
   Finds the node matching the character ch.
*/

function findNode(ch) {
  if (doPFSort) return null;
  if (ch == this.letter || (this.level == this.depth)) {
    return this.index;
  }
  else if (ch < this.letter) return this.lower.findNode(ch);
  else return this.upper.findNode(ch);
}

/* function jump()
    Jumps to the found item.  If in find classes mode, sets the class page;
    if in find method mode, scrolls the class page to that method.
*/

function jump() {
  if (findMode == FIND_CLASS) classLoc.href = link.href;
  else if (findMode == FIND_METHOD) {
    classLoc.hash = methodA.hash;
  }
  resetTimers();
}

/* function goToXX( Event e)
     Separate versions for N4, N6, and IE
     The onkeydown handler, which attempts to match the key(s) pressed so
     far to an entry in pflinks.
     Resets all timers/intervals.
*/
	
function goToN4(e) {
  if ((e.modifiers & Event.CONTROL_MASK) > 0) return true;
  var fr = null, key;
  if (timer != null) { clearTimeout(timer); timer = null; }
  if (reset != null) { clearTimeout(reset); reset = null; }
  count++;
  var keyCode = e.which, lcKey;
  if (keyCode == 0) return resetTimers();
  if (keyCode == CR) {
    jump();
		setFocus();
		return false;
  }
	else if (keyCode == UP) {
	  goScroll(UP);
		setFocus();
		return false;
	}
	else if (keyCode == DN) {
	  goScroll(DN);
		setFocus();
		return false;
	}
  key = String.fromCharCode(keyCode);
  if (key == "_") {
    if (keys == "") {
      packageFrame.scrollTo(0, packageFrame.document.height);
      return resetTimers(); 
    }
  }
  lcKey = key.toLowerCase();
  if (e.modifiers == 4) {
    if (lcKey >= "a" && lcKey <= "z") {
      if (lcKey == "f") goF();
      else if (lcKey == "c") goC();
      else if (lcKey == "m") goM();
      else if (lcKey == "i" || lcKey == "n") goI();
  		//else if (!hasControlFrame && lcKey == "p") togglePause();
      return resetTimers();
      }
    if (keyCode != "_" && keyCode != "$") return resetTimers();
  }
  keys += lcKey;
  goScroll(findMode);
	return resetTimers();
  }

function goToIE(e) {
  var fr = null, key;
	if ((typeof focusFrame == "undefined") || (focusFrame == null)) focusFrame = classFrame;
  if (timer != null) { clearTimeout(timer); timer = null; }
  if (reset != null) { clearTimeout(reset); reset = null; }
  count++;
  if ((fr = findIEEventFrame()) == null) return resetTimers();
  e = fr.event;
	if (e.ctrlKey) { return true; }
  ch = e.keyCode;
  if (ch == CR) {
    jump();
    return false;
  }
  else if (ch == ESC) {
    cancelGoTo();
    return false;
  }
	else if (ch == PGUP) {
		focusFrame.scrollBy(0, -focusFrame.frameElement.clientHeight);
  } 
	else if (ch == PGDN) {
	  focusFrame.scrollBy(0, focusFrame.frameElement.clientHeight);
	}
  else if ((ch == ASTERISK1) || (e.shiftKey && (ch == ASTERISK2))) {
    toggleFindMode();
    cancelGoTo();
    return false;
  }
	else if (ch == UP) {
	  return goScroll(UP);
	}
	else if (ch == DN) {
	  return goScroll(DN);
	}
  if (ch == _CharIE) {
    if (keys == "") { // and findMode == FIND_CLASS ?
		  keys = "_";
      return goScroll('_');
		}
    key = "_";  
  }
  else {
    key = String.fromCharCode(ch).toLowerCase();
    if (e.shiftKey) {
      if (key == "f") goF();
      else if (key == "c") goC();
      else if (key == "m") goM();
      else if (key == "i" || key == "n") goI();
			else if (!hasControlFrame && key == "p") togglePause();
      return cancelGoTo();
     }
    if ( (  !(key >= "a" && key<= "z") 
         && !(key >="0" && key <= "9") 
         && key != "$")
         || e.altKey || e.ctrlKey) 
      return resetTimers();
  }
  keys += key;
  goScroll(findMode);
}

function goToN6(e) {
  if (e.ctrlKey) return true;
  var fr = null, key;
  if (timer != null) { clearTimeout(timer); timer = null; }
  if (reset != null) { clearTimeout(reset); reset = null; }
  count++;
	e.stopPropagation();
  e.cancelBubble = true;
	e.preventDefault();
	e.preventBubble();
	e.preventCapture();
  ch = (e.keyCode) ? e.keyCode :
       (e.charCode) ? e.charCode : e.which;
  if (ch == CR) {
    jump();
    return false;
    }
  else if (ch == ESC) {
    cancelGoTo();
    return false;
    }
  else if ((ch == ASTERISK1) || (e.shiftKey && (ch == ASTERISK2))) {
    toggleFindMode();
    cancelGoTo();
    return false;
    }
  else if (ch == _CharNS6) {
    if (keys == "") { // and findMode == FIND_CLASS ?
		  keys = "_";
      goScroll('_');
      return false;
			}
    key = "_";  
    }
  else if (ch == UP) {
	  goScroll(UP);
    return false;
		}
	else if (ch == DN) {
	  goScroll(DN);
    return false;
		}
	else key = String.fromCharCode(ch).toLowerCase();
  if (e.shiftKey) {
    if (key == "f") goF();
    else if (key == "c") goC();
    else if (key == "m") goM();
    else if (key == "i" || key == "n") goI();
  	//else if (!hasControlFrame && key == "p") togglePause();
    return cancelGoTo();
    }
  if (key < "a" || key > "z" || e.altKey || e.ctrlKey) 
    return resetTimers();
  keys += key;
  e.cancelBubble = true;
  goScroll(findMode);
  return false;
  }

/* function goScroll(special) 
   Performs the scrolling.
*/

function goScroll(special) {
var scrollLink = null, chUpDn = false;  // NS6 scroll/arrow kludge
  if (findMode == FIND_CLASS) {
    if (special == DN) {
      scrollLink = pflinks[current+(hasControlFrame ? 1 : 0)];
      if (++current >= pflinks.length) current--;
      cancelGoTo();
			chUpDn = true;
			start = current;
      link = pflinks[start];
      path = getLinkText(link);
      }
    else if (special == UP) {
      scrollLink = pflinks[current-(hasControlFrame ? 1 : 0)];
      if (--current < 0) current = 0;
      cancelGoTo();
			chUpDn = true;
      start = current;
      link = pflinks[start];
      path = getLinkText(link);
      }
    else {
      if (count == 1) {
        //need to find in index list
        if (doPFSort) current = start = firstLetterIndexes[keys];
        //current = start = _ClassLoc;
        else current = start = tree.findNode(keys);
        singleFind(1);
        //jumpFind(1);
        }
      else if (count == 2) jumpFind(2);
      else singleFind(count);
      }
    if (hasControlFrame) tSearch.focus()
		else if (link.focus) {
		link.focus();
		}
		else {
		packageFrame.focus();
		}
    if (isIE || isN6) {
      if (shouldShowFound) showFound();
      packageFrame.scrollTo(0, ((isN6 && chUpDn) ? scrollLink : link).offsetTop);
      }
    else if (isN4) {
      packageFrame.scrollTo(0, 
          current * packageFrame.document.height / pflinks.length - 100);
      }
    if (hasControlFrame) tFound.value = path;  
    return resetTimers();
    }
  if (findMode == FIND_METHOD) {
	  if (!findModeOK) {
		  tempkeys = keys;
		  setupFindMethod();
      keys = tempkeys;
		  }
		goScrollMethod(special);
    }
  return resetTimers();//false;
  }

function jumpFind(numChars) {
	for (var i = start + JUMP_FWD; i < pflinks.length; i += JUMP_FWD) { 
		link = pflinks[i];
		path = getLinkText(link);
		name = path.substr(0, numChars);
		if ((name.substr(0,1) == '_' && keys.substr(0,1) != '_')
		    ||  (name >= keys)) {
			i -= JUMP_FWD;
			if (i < 0) i = 0;
			current = start = i;
			break;
			}
		}
  singleFind(numChars);
	}
	
function singleFind(numChars) {
	for (var i = start; i < pflinks.length; i++) { 
		link = pflinks[i];
		path = getLinkText(link);
		name = path.substr(0, numChars);
		if (name >= keys || i == (pflinks.length - 1)) break;
		}
	start = current = i;
	if (hasControlFrame) tSearch.focus();
  return resetTimers();
  }

/* function showFound()
     highlights the class that was found, dehighlights the previous class
*/

function showFound() {
  lastLink.style.color = oldColor;
  if (link != null) {
    oldColor = link.currentStyle ? link.currentStyle.color : link.style.color;
    link.style.color = "red";
    lastLink = link;
    }
  }

function resetTimers() {
  if (timer != null) {
	  clearTimeout(timer);
		timer = null;
		}
	if (reset != null) {
	  clearTimeout(reset);
		reset = null;
		}
	if (!paused) {
	  timer = setTimeout("cancelGoTo()", keyTimeout);
	  reset = setTimeout("reInit()", refreshRate);
		}
  return false;
  }

/* function setPause(set)
   Sets or cancels timeouts so that a selection can be highlighted
	 and copied, etc.
*/

function setPause(set) {
	if (set) {
	  if (timer != null) clearTimeout(timer);
	  if (reset != null) clearTimeout(reset);
		}
	paused = set;
	}

/* function togglePause()
   Cancels timeouts so that a selection can be highlighted
	 and copied, etc.
*/

function togglePause() {
  setPause(!paused);
  return false;
  }

/* function cancelGoTo()
   Resets the search, called after a timer of keyTimeout milliseconds,
	  so that a long enough pause in typing will wipe out the search string
		and start anew.
*/		

function cancelGoTo() {
  start = findMode;
  count = 0;
  keys = "";
  timer = null;
  if (hasControlFrame) tSearch.value = "";
  reInit();
  return false;
  }

/* function goX()
   Set of functions to jump to sections for fields, constructors, methods,
   and inner classes.
*/	 

function goF() {
  classLoc.hash = "field_summary";
  classFrame.scrollBy(-200, 0);
  cancelGoTo();
  resetTimers();
  }

function goC() { 
  classLoc.hash = "constructor_summary";
  classFrame.scrollBy(-200, 0);
  cancelGoTo();
  resetTimers();
  }

function goM() { 
  classLoc.hash = "method_summary";
  classFrame.scrollBy(-200, 0);
  cancelGoTo();
  resetTimers();
  }

function goI() {
  if (isN4) {
		var anchorElt = null; anchorArray = classFrame.document.anchors;
		for (var i=0; i<anchorArray.length; i++) {
			if  ((anchorElt = anchorArray[i]).name == "inner_class_summary"
					 || anchorElt.name == "nested_class_summary") break;  }
		if (anchorElt != null) classFrame.scrollTo(0, anchorElt.y);
    }
	else {
		classLoc.hash = "inner_class_summary"; 
		classLoc.hash = "nested_class_summary";
		classFrame.scrollBy(-200, 0);
		}
  cancelGoTo();
  resetTimers();
  }

/* function toggleFindMode() 
   Toggles between find class and find method behavior
*/
	 
function toggleFindMode() {
	if (isN4) return;
  if (hasControlFrame) fForm.bFindMode.value = findModes[findMode];
	findMode = findMode ^ 1;
	findModeOK = false;
  if (hasControlFrame) keyFinderFrame.document.body.style.backgroundColor = modeBgs[findMode];
	cancelGoTo();
  if (findMode == FIND_METHOD) setupFindMethod();
	return resetTimers();
	}

/* function setupFindMethod() 
   Prepares for find method behavior by searching for the method area
   links
*/
	 
function setupFindMethod() {
  if (isN4) return;
  var ancs = classFrame.document.anchors;
  methodA = methodRows = null;
  for (i=0; i<ancs.length; i++)  {
    if (ancs[i].name=='method_summary') {
      methodA = ancs[i];
      break;
      }
    }
  var methodsList;
  if (methodA != null) {
    if (typeof methodA.nextSibling.tagName == 'undefined') 
		  methodA = methodA.nextSibling;
    methodRows = methodA.nextSibling.getElementsByTagName('tr');
	  }
	findModeOK = true;
  goM();
  }

/* function clearFindModeOK ()
   Clears flag that indicates find method is set up properly
*/
	 
function clearFindModeOK (e) {
  setFocusFrame(e);
  findModeOK = false; 
	setFocus();
  }

/* function goScrollMethod(special)
   Scrolls to the found method.
*/
	 
function goScrollMethod(special) {
  if (methodRows != null) {
    for(i=start; i<methodRows.length; i++) {
      methodRow = methodRows[i];
      methodA = ((methodRow.getElementsByTagName('td'))[1].getElementsByTagName('a'))[0];
			methodName = methodA.hash;
      methodName = 
        methodName.substring(1,methodName.indexOf('(')).toLowerCase();
      if (methodName == keys) break;
      name = methodName.substr(0, count).toLowerCase();
      if (name >= keys) {
        if (i < methodRows.length) {
          if (isIE || isN6 ) {
            var tmpP = methodA, oTop = methodA.offsetTop;
            while (tmpP.offsetParent) {
              tmpP = tmpP.offsetParent;
              oTop += tmpP.offsetTop;
              }
            classFrame.scrollTo(0, oTop);
            }
          else if (isN6) classFrame.scrollTo(0, methodA.offsetTop);
          }
        break;
        }
      }
    }
  return resetTimers();
	}

/* function goToMethodIE(e) {
   Special method for IE, to scroll to the method that was found
*/
	 
function goToMethodIE(e) {
  var fr = null;
  if (timer != null) { clearTimeout(timer); timer = null; }
  if (reset != null) { clearTimeout(reset); reset = null; }
  count++;
  e = keyFinderFrame.event;
  ch = e.keyCode;
  if (ch == CR) return;
  var key;
  if (ch == 189) {
    if (keys == "") {
      goScroll('_');
      return resetTimers();
      }
    key = "_";
    }
  else {
    key = String.fromCharCode(ch).toLowerCase();
    if ( (  !(key >= "a" && key<= "z") 
           && !(key >="0" && key <= "9") 
           && key != "$")
           || e.altKey || e.ctrlKey) 
      return resetTimers();
    }
  keys += key;
  goScroll(0);
  }

function setFocus() {
  if (!paused) {
		if (hasControlFrame) tSearch.focus();
		else packageFrame.focus();
		}
  }

function getLinkTextN6(link) {
  return (link.firstChild.innerHTML ? link.firstChild : link).innerHTML.toLowerCase();
	}
	
// added line below for debugging
var tempMsg = "", tempcount = 0;

function getLinkTextOther(link) {
  var path = link.pathname;
  return path.substring(Math.max(path.lastIndexOf("/"),
                             path.lastIndexOf("\\")) + 1,
                             path.lastIndexOf(".")).toLowerCase();
	}

/* function pfClick
   handles clicks in package frame - used to set red color on link, 
	 also calls clearFindModeOK
*/
function pfClick(e) {
  setFocusFrame(e);
  if (packageFrame.event) {
	  e = packageFrame.event;
		}
	if (e.srcElement) {
		if (e.srcElement.pathname) link = e.srcElement;
		else if (e.srcElement.parentElement.pathname) 
			link = e.srcElement.parentElement;
		else { setFocus(); return false; }
		}
	else if (e.originalTarget && e.originalTarget.parentNode) {
		if (e.originalTarget.parentNode.pathname) { 
			link = e.originalTarget.parentNode;
			}
		else if (e.originalTarget.parentNode.parentNode
		         && e.originalTarget.parentNode.parentNode.pathname) {
			link = e.originalTarget.parentNode.parentNode;
			}
		else { setFocus(); return false; }
		}
  else if (e.target) {
		link = e.target;
		}
	else { setFocus(); return false; }
	
	// here is where clicked link is found in list
	keys = getLinkText(link);
	
// ********************************************* modified line below 20041102
	if (!doPFSort) current = start = tree.findNode(keys.substr(0,1));
	jumpFind(keys.length);
	if (shouldShowFound) showFound();
	if (hasControlFrame) tFound.value = keys;
	clearFindModeOK();
	setFocus();
	}

/* function controlFrameInit()
   Performs some initializations specific to
	 the control frame version
*/
function controlFrameInit() {
  fForm = keyFinderFrame.document.f;
  tSearch = fForm.txtTyped;
  tFound = fForm.txtFound;
  tSearch.onkeydown = goTo;
  if (isN4) keyFinderFrame.document.captureEvents(Event.CLICK);
	keyFinderFrame.document.onclick = setFocus;
	keyFinderFrame.setCodeFrame(window);
  packageFrame.document.onclick = pfClick;
	if (!isN4) fForm.bFindMode.value = "Find Methods";
  }
	
/* function initKeys()
   Performs some initializations specific to
	 the non-control frame version
*/
	
function initKeys() {
    packageListFrame.document.onkeydown = goTo;
    packageFrame.document.onkeydown = goTo;
    classFrame.document.onkeydown = goTo;
  }

/* function findIEEventFrame()
   For IE, finds which frame generated the event, since the frame 
   owns the event object
*/
	 
function findIEEventFrame() {
  if (hasControlFrame) return keyFinderFrame;
	else {
	  var fr = null;
		if (packageListFrame.event) fr = packageListFrame;
		else if (packageFrame.event) fr = packageFrame;
		else if (classFrame.event) fr = classFrame;
		return fr;
		}
  }

function setFocusFrameIE(e) {
	focusFrame = 
	  (packageListFrame.event) ? packageListFrame :
	  (packageFrame.event) ? packageFrame :
	  (classFrame.event) ? classFrame : focusFrame;
	}

function setFocusFrameN4(e) {
	focusFrame = e.target;
	}

function setFocusFrameN6(e) {
	if (typeof(event) != 'undefined') e = event;
	examine(e);
	if (typeof(e) != 'undefined') focusFrame = e.currentTarget;
	}

/* function clone(elt)
   This clones the object x.
*/
function clone(elt) {  
  var newElt = new Array();
  if ((typeof elt.length) != 'undefined') {
      for (i=0; i<elt.length; i++ ){
        newElt[i] = elt[i]; 
        }
      }
  for (x in elt) {
    newElt[x] = elt[x];
    }

  return newElt;
  }

function sortLinks(a, b) {
  
  var aa = a.linkText;
  var bb = b.linkText;
  if (a.firstCharIsUnderscore && !b.firstCharIsUnderscore) return 1;
  else if (!a.firstCharIsUnderscore && b.firstCharIsUnderscore) return -1;
  else if (aa < bb) return -1;
  else return 1;
  
/* old version pre 20040826

  var aa = getLinkText(a);
  var bb = getLinkText(b);
  if (aa.charAt(0) == '_' && bb.charAt(0) != '_') return 1;
  else if (aa.charAt(0) != '_' && bb.charAt(0) == '_') return -1;
  else if (aa.toLowerCase() < bb.toLowerCase()) return -1;
  else return 1;
*/
}